unit unit01;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Cb_Graph, Cb_lab, Buttons, ExtCtrls, Tabs,
  Grids, DBGrids, DB, DBTables, Cb_dbgr, PrnWin, DBPrnWin, Cb_grid,
  PrnGridR, CB_MFunc, CB3Party;

type
  TCBDemo01 = class(TForm)
    Notebook1: TNotebook;
    BitBtn1: TBitBtn;
    DataSource1: TDataSource;
    DBPrintWin1: TDBPrintWin;
    PrintGridReport1: TPrintGridReport;
    Memo1: TMemo;
    Query1: TQuery;
    Query1SYMBOL: TStringField;
    Query1CUR_PRICE: TFloatField;
    Query1YRL_HIGH: TFloatField;
    Query1YRL_LOW: TFloatField;
    Query1P_E_RATIO: TFloatField;
    Query1BETA: TFloatField;
    Query1PROJ_GRTH: TFloatField;
    ScrollBox1: TScrollBox;
    CB_Label2: TCB_Label;
    CB_DBGraph1: TCB_DBGraph;
    CB_SortGrid1: TCB_SortGrid;
    ComboBox2: TComboBox;
    Label1: TLabel;
    Button1: TButton;
    Button2: TButton;
    TabSet1: TTabSet;
    Image1: TImage;
    procedure FormCreate(Sender: TObject);
    procedure TabSet1Click(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure CB_SortGrid1AfterSort(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
	 procedure LoadTenValues;
	 procedure LoadTenValueNames;
  public
    { Public declarations }
  end;

var
  CBDemo01: TCBDemo01;

implementation

{$R *.DFM}


procedure TCBDemo01.FormCreate(Sender: TObject);
begin
	CB_DBGraph1.GraphType := ctBar;
	CB_DBGraph1.NValues := 10;
   LoadTenValues;
   LoadTenValueNames;
	CB_DBGraph1.AdjustScale;
end;

procedure TCBDemo01.LoadTenValues;
begin
   CB_DBGraph1.LoadSeries(1,Query1, Query1CUR_PRICE);
   CB_DBGraph1.LoadSeries(2,Query1, Query1YRL_HIGH);
   CB_DBGraph1.LoadSeries(3,Query1, Query1YRL_LOW);
   CB_DBGraph1.LoadSeries(4,Query1, Query1P_E_RATIO);
   CB_DBGraph1.LoadSeries(5,Query1, Query1BETA);
   CB_DBGraph1.LoadSeries(6,Query1, Query1PROJ_GRTH);
end;


procedure TCBDemo01.TabSet1Click(Sender: TObject);
begin
	Notebook1.PageIndex := Tabset1.TabIndex;
end;

procedure TCBDemo01.ComboBox2Change(Sender: TObject);
begin
	if ComboBox2.ItemIndex = 0 then
		CB_DBGraph1.GraphType := ctBar;
	if ComboBox2.ItemIndex = 1 then
		CB_DBGraph1.GraphType := ctLine;
	if ComboBox2.ItemIndex = 2 then
		CB_DBGraph1.GraphType := ctPie;
	if ComboBox2.ItemIndex = 3 then
		CB_DBGraph1.GraphType := ctScatter;

end;

procedure TCBDemo01.Button1Click(Sender: TObject);
begin
	PrintGridReport1.Execute;
end;

procedure TCBDemo01.Button2Click(Sender: TObject);
begin
	DBPrintWin1.BeginPrint;
	DBPrintWin1.DrawWindowAt(1.5,2,ScrollBox1);
	DBPrintWin1.EndPrint;
end;

procedure TCBDemo01.CB_SortGrid1AfterSort(Sender: TObject);
begin
   CB_SortGrid1.Refresh;
	LoadTenValues;
	CB_DBGraph1.AdjustScale;
   LoadTenValueNames;
	CB_DBGraph1.Repaint;
end;

{ Loads the first 10 Value Names into the Graph
  For this demo it is the Share Symbol }
procedure TCBDemo01.LoadTenValueNames;
var
   i: integer;
   MyBookmark: TBookmark;
begin
	with Query1 do begin
		DisableControls;
   	MyBookmark := Query1.GetBookmark;

   	First;
   	i := 0;
  		while not Eof do begin
 			if i = 10 then
      		Break;
      	CB_DBGraph1.ValueNames[i] := Query1SYMBOL.AsString;
  			Next;
      	Inc(i);
   	end;
   	GoToBookmark (MyBookmark);
   	FreeBookmark (MyBookmark);
        
   	EnableControls;
   end;
   CB_SortGrid1.Refresh;

end;

procedure TCBDemo01.BitBtn1Click(Sender: TObject);
begin
	Close;
end;

end.
